// public/assets/js/app.js

(function () {
  function copyText(txt) {
    if (!txt) return;
    if (navigator.clipboard && navigator.clipboard.writeText) {
      navigator.clipboard.writeText(txt).then(function(){}, function(){ fallback(txt); });
    } else {
      fallback(txt);
    }
    function fallback(t) {
      var ta = document.createElement('textarea');
      ta.value = t;
      ta.style.position = 'fixed';
      ta.style.left = '-9999px';
      document.body.appendChild(ta);
      ta.select();
      try { document.execCommand('copy'); } catch(e) {}
      document.body.removeChild(ta);
    }
  }

  document.addEventListener('click', function (e) {
    var btn = e.target.closest('.js-copy');
    if (!btn) return;
    var data = btn.getAttribute('data-copy') || '';
    copyText(data);
    btn.classList.add('btn-success');
    setTimeout(function(){ btn.classList.remove('btn-success'); }, 600);
  });
})();
