<?php
// edit.php
declare(strict_types=1);
require_once dirname(__DIR__, 2).'/config/functions.php';
require_role(['Admin','Ops']);
$cid = current_user()['company_id'] ?? null; if (!$cid) redirect(url_public('index.php'));
$id = (int)($_GET['id'] ?? 0); if ($id<=0) redirect('list.php');

$sel = db()->prepare("SELECT * FROM vehicles WHERE id=:id AND company_id=:cid LIMIT 1");
$sel->execute([':id'=>$id, ':cid'=>$cid]); $v=$sel->fetch(); if(!$v) redirect('list.php');

$errors=[];
if($_SERVER['REQUEST_METHOD']==='POST'){
  try{
    csrf_verify((string)($_POST['csrf'] ?? ''));
    $reg=trim((string)($_POST['reg_no'] ?? '')); $type=trim((string)($_POST['type'] ?? ''));
    $make=trim((string)($_POST['make_model'] ?? '')); $cap=trim((string)($_POST['capacity'] ?? ''));
    $sts=(string)($_POST['current_status'] ?? 'available'); $svc=(string)($_POST['last_service_date'] ?? '');
    if($reg===''||$type==='') $errors[]='Reg No and Type are required.';
    if(!$errors){
      $upd=db()->prepare("UPDATE vehicles SET reg_no=:reg,type=:type,make_model=:make,capacity=:cap,current_status=:sts,last_service_date=:svc WHERE id=:id AND company_id=:cid");
      $upd->execute([':reg'=>$reg,':type'=>$type,':make'=>$make,':cap'=>$cap,':sts'=>$sts,':svc'=>$svc?:null,':id'=>$id,':cid'=>$cid]);
      audit_log('vehicle.update','vehicle',$id,['fields'=>['reg_no','type','make_model','capacity','current_status','last_service_date']]);
      redirect('list.php');
    }
  }catch(Throwable $e){ $errors[]=(APP_ENV==='dev')?$e->getMessage():'Unexpected error.'; }
}
include dirname(__DIR__,2).'/includes/header.php';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h4 mb-0">Edit Vehicle</h1>
  <a href="list.php" class="btn btn-outline-secondary">Back</a>
</div>
<div class="card shadow-sm"><div class="card-body">
<?php if($errors): ?><div class="alert alert-danger"><ul class="mb-0"><?php foreach($errors as $e) echo '<li>'.e($e).'</li>'; ?></ul></div><?php endif; ?>
<form method="post">
  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
  <div class="row g-3">
    <div class="col-md-4"><label class="form-label">Reg No</label><input class="form-control" name="reg_no" required value="<?= e($_POST['reg_no'] ?? $v['reg_no']) ?>"></div>
    <div class="col-md-4"><label class="form-label">Type</label><input class="form-control" name="type" required value="<?= e($_POST['type'] ?? $v['type']) ?>"></div>
    <div class="col-md-4"><label class="form-label">Make/Model</label><input class="form-control" name="make_model" value="<?= e($_POST['make_model'] ?? $v['make_model']) ?>"></div>
    <div class="col-md-4"><label class="form-label">Capacity</label><input class="form-control" name="capacity" value="<?= e($_POST['capacity'] ?? $v['capacity']) ?>"></div>
    <div class="col-md-4">
      <label class="form-label">Status</label>
      <select class="form-select" name="current_status">
        <?php foreach (['available','rented','maintenance'] as $s): ?>
          <option value="<?= e($s) ?>" <?= ($s===$v['current_status'])?'selected':'' ?>><?= ucfirst($s) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-4"><label class="form-label">Last Service Date</label><input type="date" class="form-control" name="last_service_date" value="<?= e($_POST['last_service_date'] ?? $v['last_service_date']) ?>"></div>
  </div>
  <div class="mt-3"><button class="btn btn-dark">Save Changes</button></div>
</form>
</div></div>
<?php include dirname(__DIR__,2).'/includes/footer.php'; ?>
