<?php
declare(strict_types=1);

/**
 * config/config.php
 * Global app & database configuration.
 * NOTE: Do NOT declare db() here — functions.php provides it.
 */

// ---- App ----
define('APP_ENV', 'dev');              // 'dev' or 'prod'

// IMPORTANT: Set your app base path (leading & trailing slash).
// For http://localhost/cmrs/, use '/cmrs/'. For root vhost, use '/'.
define('APP_BASE_PATH', '/cmrs/');

// Build a stable BASE_URL so url_*() helpers don't depend on SCRIPT_NAME.
// This prevents duplicates like /modules/modules/... when inside modules pages.
$__scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? 'https' : 'http';
$__host   = $_SERVER['HTTP_HOST'] ?? 'localhost';
$__path   = rtrim(APP_BASE_PATH, '/') . '/';
define('BASE_URL', $__scheme . '://' . $__host . $__path);

// ---- Database ----
define('DB_HOST', '127.0.0.1');
define('DB_NAME', 'rainfnjk_cmrs');
define('DB_USER', 'rainfnjk_cmrs_user');
define('DB_PASS', 'Madu@0418');                 // XAMPP default; change in production

// DSN used by functions.php::db()
define('DB_DSN', 'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=utf8mb4');

// In dev, show errors (optional; you can remove this in prod)
if (APP_ENV === 'dev') {
  error_reporting(E_ALL);
  ini_set('display_errors', '1');
} else {
  error_reporting(E_ALL & ~E_NOTICE & ~E_STRICT & ~E_DEPRECATED);
  ini_set('display_errors', '0');
}
